library(memisc)
library(magrittr)
# CHES.data <- Stata.file("Data/ChapelHill/1999-2014_CHES_dataset_means-3.dta")
library(readstata13)

CHES <- read.dta13("Data/ChapelHill/1999-2019_CHES_dataset_means(v2).dta")
CHES.label.table <- attr(CHES,"label.table")
CHES.country.labs <- CHES.label.table$country
CHES.partycodes <- subset(CHES,select=c(
                                   country,
                                   party,
                                   party_id,
                                   cmp_id
                               ))

CHES.partycodes <- within(CHES.partycodes,{
    country.name <- names(CHES.country.labs)[match(country,CHES.country.labs)]
})
CHES.partycodes <- unique(CHES.partycodes)

CHES.partycodes <- sort(CHES.partycodes,
                        by=~party+country.name)

CHESwork <- subset(CHES,
                   select=c(
                       country,
                       party_id,
                       year,
                       lrgen,
                       lrecon,
                       lrecon_salience,
                       lrecon_dissent,
                       lrecon_blur,
                       galtan,
                       galtan_salience,
                       galtan_dissent,
                       galtan_blur,
                       spendvtax,
                       spendvtax_salience,
                       deregulation,
                       dereg_salience,
                       redistribution,
                       redist_salience,
                       civlib_laworder,
                       civlib_salience,
                       sociallifestyle,
                       social_salience,
                       religious_principles,
                       relig_salience,
                       immigrate_policy,
                       immigrate_salience,
                       immigrate_dissent,
                       multiculturalism,
                       multicult_salience,
                       multicult_dissent,
                       urban_rural,
                       urban_salience,
                       environment,
                       enviro_salience,
                       cosmo,
                       cosmo_salience,
                       protectionism,
                       regions,
                       region_salience,
                       international_security,
                       international_salience,
                       us,
                       us_salience,
                       ethnic_minorities,
                       ethnic_salience,
                       nationalism,
                       anti_islam_rhetoric,
                       people_vs_elite,
                       antielite_salience,
                       corrupt_salience,
                       members_vs_leadership,
                       chesversion,
                       family
                   ))

CHESwork %<>% rename(year="CHESyear",
                     family="partfam",
                     immigrate_policy="immigration",
                     region="decentralization")

save(CHESwork,
     file="CHESwork.RData")
